/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.graphics.textmc;

import javax.annotation.Nonnull;
import net.minecraft.util.text.Style;

public class FormattingStyle {
    public static final byte PLAIN = 0;
    public static final byte BOLD = 1;
    public static final byte ITALIC = 2;
    private static final byte FONT_STYLE_MASK = 3;
    private static final byte UNDERLINE_MASK = 4;
    private static final byte STRIKETHROUGH_MASK = 8;
    private static final byte OBFUSCATED_MASK = 16;
    public static final int NO_SPECIFIED_COLOR = -1;
    public final int stringIndex;
    public final int stripIndex;
    private final int color;
    private final byte flags;

    public FormattingStyle(int stringIndex, int stripIndex, Style style) {
        this.stringIndex = stringIndex;
        this.stripIndex = stripIndex;
        this.color = FormattingStyle.getColor(style);
        this.flags = FormattingStyle.getFlags(style);
    }

    public static int getColor(@Nonnull Style style) {
        return style.func_240711_a_() == null ? -1 : style.func_240711_a_().func_240742_a_();
    }

    public int getColor() {
        return this.color;
    }

    public static byte getFlags(@Nonnull Style style) {
        byte v = 0;
        if (style.func_150223_b()) {
            v = (byte)(v | 1);
        }
        if (style.func_150242_c()) {
            v = (byte)(v | 2);
        }
        if (style.func_150234_e()) {
            v = (byte)(v | 4);
        }
        if (style.func_150236_d()) {
            v = (byte)(v | 8);
        }
        if (style.func_150233_f()) {
            v = (byte)(v | 0x10);
        }
        return v;
    }

    public int getFontStyle() {
        return this.flags & 3;
    }

    public boolean isUnderline() {
        return (this.flags & 4) != 0;
    }

    public boolean isStrikethrough() {
        return (this.flags & 8) != 0;
    }

    public boolean isObfuscated() {
        return (this.flags & 0x10) != 0;
    }

    public boolean layoutStyleEquals(@Nonnull FormattingStyle s2) {
        return this.flags == s2.flags;
    }
}

